/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CL_ImageSelection
implements Transferable {
    private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
    private Image image = null;

    public static void copyImageToClipboard(Image _image) {
        CL_ImageSelection imageSelection = new CL_ImageSelection(_image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public static BufferedImage getClipboardImage() {
        boolean hasTransferable;
        BufferedImage result = null;
        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        boolean bl = hasTransferable = contents != null && contents.isDataFlavorSupported(DataFlavor.imageFlavor);
        if (hasTransferable) {
            try {
                result = (BufferedImage)contents.getTransferData(DataFlavor.imageFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public CL_ImageSelection(Image image) {
        this.image = image;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.imageFlavor)) {
            return this.image;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

