/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.util.locale.Extension;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleUtils;
import sun.util.locale.UnicodeLocaleExtension;

public class LocaleExtensions {
    private final Map<Character, Extension> extensionMap;
    private final String id;
    public static final LocaleExtensions CALENDAR_JAPANESE = new LocaleExtensions("u-ca-japanese", Character.valueOf('u'), UnicodeLocaleExtension.CA_JAPANESE);
    public static final LocaleExtensions NUMBER_THAI = new LocaleExtensions("u-nu-thai", Character.valueOf('u'), UnicodeLocaleExtension.NU_THAI);

    private LocaleExtensions(String string, Character c, Extension extension) {
        this.id = string;
        this.extensionMap = Collections.singletonMap(c, extension);
    }

    /*
     * WARNING - void declaration
     */
    LocaleExtensions(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> map, Set<InternalLocaleBuilder.CaseInsensitiveString> set, Map<InternalLocaleBuilder.CaseInsensitiveString, String> map2) {
        boolean bl;
        boolean bl2 = !LocaleUtils.isEmpty(map);
        boolean bl3 = !LocaleUtils.isEmpty(set);
        boolean bl4 = bl = !LocaleUtils.isEmpty(map2);
        if (!(bl2 || bl3 || bl)) {
            this.id = "";
            this.extensionMap = Collections.emptyMap();
            return;
        }
        TreeMap<Character, Extension> treeMap = new TreeMap<Character, Extension>();
        if (bl2) {
            for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveChar, String> object : map.entrySet()) {
                void var11_17;
                String string;
                char unicodeLocaleExtension = LocaleUtils.toLower(object.getKey().value());
                String string2 = object.getValue();
                if (LanguageTag.isPrivateusePrefixChar(unicodeLocaleExtension) && (string = InternalLocaleBuilder.removePrivateuseVariant(string2)) == null) continue;
                treeMap.put(Character.valueOf(unicodeLocaleExtension), new Extension(unicodeLocaleExtension, LocaleUtils.toLowerString((String)var11_17)));
            }
        }
        if (bl3 || bl) {
            void var9_12;
            Object object3 = null;
            Object var9_10 = null;
            if (bl3) {
                object3 = new TreeSet();
                for (InternalLocaleBuilder.CaseInsensitiveString caseInsensitiveString : set) {
                    object3.add(LocaleUtils.toLowerString(caseInsensitiveString.value()));
                }
            }
            if (bl) {
                TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveString, String> entry : map2.entrySet()) {
                    String string = LocaleUtils.toLowerString(entry.getKey().value());
                    String string3 = LocaleUtils.toLowerString(entry.getValue());
                    treeMap2.put(string, string3);
                }
            }
            UnicodeLocaleExtension unicodeLocaleExtension = new UnicodeLocaleExtension((SortedSet<String>)object3, (SortedMap<String, String>)var9_12);
            treeMap.put(Character.valueOf('u'), unicodeLocaleExtension);
        }
        if (treeMap.isEmpty()) {
            this.id = "";
            this.extensionMap = Collections.emptyMap();
        } else {
            this.id = LocaleExtensions.toID(treeMap);
            this.extensionMap = treeMap;
        }
    }

    public Set<Character> getKeys() {
        if (this.extensionMap.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.extensionMap.keySet());
    }

    public Extension getExtension(Character c) {
        return this.extensionMap.get(Character.valueOf(LocaleUtils.toLower(c.charValue())));
    }

    public String getExtensionValue(Character c) {
        Extension extension = this.extensionMap.get(Character.valueOf(LocaleUtils.toLower(c.charValue())));
        if (extension == null) {
            return null;
        }
        return extension.getValue();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        Extension extension = this.extensionMap.get(Character.valueOf('u'));
        if (extension == null) {
            return Collections.emptySet();
        }
        assert (extension instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)extension).getUnicodeLocaleAttributes();
    }

    public Set<String> getUnicodeLocaleKeys() {
        Extension extension = this.extensionMap.get(Character.valueOf('u'));
        if (extension == null) {
            return Collections.emptySet();
        }
        assert (extension instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)extension).getUnicodeLocaleKeys();
    }

    public String getUnicodeLocaleType(String string) {
        Extension extension = this.extensionMap.get(Character.valueOf('u'));
        if (extension == null) {
            return null;
        }
        assert (extension instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)extension).getUnicodeLocaleType(LocaleUtils.toLowerString(string));
    }

    public boolean isEmpty() {
        return this.extensionMap.isEmpty();
    }

    public static boolean isValidKey(char c) {
        return LanguageTag.isExtensionSingletonChar(c) || LanguageTag.isPrivateusePrefixChar(c);
    }

    public static boolean isValidUnicodeLocaleKey(String string) {
        return UnicodeLocaleExtension.isKey(string);
    }

    private static String toID(SortedMap<Character, Extension> sortedMap) {
        StringBuilder stringBuilder = new StringBuilder();
        Extension extension = null;
        for (Map.Entry<Character, Extension> entry : sortedMap.entrySet()) {
            char c = entry.getKey().charValue();
            Extension extension2 = entry.getValue();
            if (LanguageTag.isPrivateusePrefixChar(c)) {
                extension = extension2;
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(extension2);
        }
        if (extension != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(extension);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocaleExtensions)) {
            return false;
        }
        return this.id.equals(((LocaleExtensions)object).id);
    }
}

