/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private DeferredCloseInputStream stdout_inner_stream;
    private InputStream stderr_stream;
    private static final LaunchMechanism launchMechanism = AccessController.doPrivileged(new PrivilegedAction<LaunchMechanism>(){

        @Override
        public LaunchMechanism run() {
            String string = System.getProperty("java.home");
            String string2 = System.getProperty("os.arch");
            if (string2.equals("x86")) {
                string2 = "i386";
            } else if (string2.equals("x86_64")) {
                string2 = "amd64";
            }
            UNIXProcess.access$002(UNIXProcess.toCString(string + "/lib/" + string2 + "/jspawnhelper"));
            String string3 = System.getProperty("jdk.lang.Process.launchMechanism", "fork");
            try {
                return LaunchMechanism.valueOf(string3.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error(string3 + " is not a supported " + "process launch mechanism on this platform.");
            }
        }
    });
    private static byte[] helperpath;

    private static byte[] toCString(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, final int[] nArray, boolean bl) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.value, helperpath, byArray, byArray2, n, byArray3, n2, byArray4, nArray, bl);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileDescriptor fileDescriptor;
                if (nArray[0] == -1) {
                    UNIXProcess.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.set(fileDescriptor, nArray[0]);
                    UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
                }
                if (nArray[1] == -1) {
                    UNIXProcess.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.set(fileDescriptor, nArray[1]);
                    UNIXProcess.this.stdout_inner_stream = new DeferredCloseInputStream(fileDescriptor);
                    UNIXProcess.this.stdout_stream = new BufferedInputStream(UNIXProcess.this.stdout_inner_stream);
                }
                if (nArray[2] == -1) {
                    UNIXProcess.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.set(fileDescriptor, nArray[2]);
                    UNIXProcess.this.stderr_stream = new DeferredCloseInputStream(fileDescriptor);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread thread = new Thread("process reaper"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                        UNIXProcess uNIXProcess = UNIXProcess.this;
                        synchronized (uNIXProcess) {
                            UNIXProcess.this.hasExited = true;
                            UNIXProcess.this.exitcode = n;
                            UNIXProcess.this.notifyAll();
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    @Override
    public synchronized void destroy() {
        if (!this.hasExited) {
            UNIXProcess.destroyProcess(this.pid);
        }
        try {
            this.stdin_stream.close();
            if (this.stdout_inner_stream != null) {
                this.stdout_inner_stream.closeDeferred(this.stdout_stream);
            }
            if (this.stderr_stream instanceof DeferredCloseInputStream) {
                ((DeferredCloseInputStream)this.stderr_stream).closeDeferred(this.stderr_stream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void init();

    static /* synthetic */ byte[] access$002(byte[] byArray) {
        helperpath = byArray;
        return byArray;
    }

    static {
        UNIXProcess.init();
    }

    private static class DeferredCloseInputStream
    extends FileInputStream {
        private Object lock = new Object();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        private DeferredCloseInputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream inputStream) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.useCount == 0) {
                    inputStream.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = inputStream;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray) throws IOException {
            this.raise();
            try {
                int n = super.read(byArray);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.raise();
            try {
                int n3 = super.read(byArray, n, n2);
                return n3;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            this.raise();
            try {
                long l2 = super.skip(l);
                return l2;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }
    }

    private static enum LaunchMechanism {
        FORK(1),
        POSIX_SPAWN(2);

        private int value;

        private LaunchMechanism(int n2) {
            this.value = n2;
        }
    }
}

