/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class NativeCipher
extends CipherSpi {
    public static final int AES_BLOCK_SIZE = 16;
    public static final String AES_KEY_ALGO = "AES";
    private final UcryptoMech mech;
    private CipherContextRef pCtxt = null;
    private int blockSize;
    private String keyAlgo;
    private byte[] keyValue = null;
    private byte[] iv = null;
    protected boolean initialized = false;
    protected boolean encrypt = true;
    protected int bytesBuffered = 0;
    private int tagLen = 0;
    private byte[] aad = null;

    private static final PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No provider found for " + string + " KeyFactory");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (InvalidKeyException)new UcryptoException("Cannot construct public key").initCause(invalidKeySpecException);
        }
        return publicKey;
    }

    private static final PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No provider found for " + string + " KeyFactory");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (InvalidKeyException)new UcryptoException("Cannot construct private key").initCause(invalidKeySpecException);
        }
        return privateKey;
    }

    private static final SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    static final Key constructKey(int n, byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key = null;
        switch (n) {
            case 3: {
                key = NativeCipher.constructSecretKey(byArray, string);
                break;
            }
            case 2: {
                key = NativeCipher.constructPrivateKey(byArray, string);
                break;
            }
            case 1: {
                key = NativeCipher.constructPublicKey(byArray, string);
            }
        }
        return key;
    }

    NativeCipher(UcryptoMech ucryptoMech, int n, String string) throws NoSuchAlgorithmException {
        this.mech = ucryptoMech;
        this.blockSize = n;
        this.keyAlgo = string;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + string);
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected synchronized int engineGetOutputSize(int n) {
        return this.doFinalLength(n);
    }

    @Override
    protected synchronized byte[] engineGetIV() {
        return this.iv != null ? (byte[])this.iv.clone() : null;
    }

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.iv != null) {
                if (this.mech == UcryptoMech.CRYPTO_AES_GCM) {
                    GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagLen, (byte[])this.iv.clone());
                    algorithmParameters = AlgorithmParameters.getInstance("GCM");
                    algorithmParameters.init(gCMParameterSpec);
                } else {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])this.iv.clone());
                    algorithmParameters = AlgorithmParameters.getInstance(this.keyAlgo);
                    algorithmParameters.init(ivParameterSpec);
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UcryptoException("Could not encode parameters", generalSecurityException);
        }
        return algorithmParameters;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length * 8;
    }

    @Override
    protected synchronized void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || key.getEncoded() == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
        }
        boolean bl = n == 1 || n == 3;
        byte[] byArray = null;
        int n2 = 0;
        if (algorithmParameterSpec != null) {
            if (this.mech == UcryptoMech.CRYPTO_AES_ECB) {
                throw new InvalidAlgorithmParameterException("No Parameters for ECB mode");
            }
            if (this.mech == UcryptoMech.CRYPTO_AES_GCM) {
                if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("GCMParameterSpec required");
                }
                byArray = ((GCMParameterSpec)algorithmParameterSpec).getIV();
                n2 = ((GCMParameterSpec)algorithmParameterSpec).getTLen();
            } else {
                if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("IvParameterSpec required");
                }
                byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
                if (byArray.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
                }
            }
        } else if (this.mech != UcryptoMech.CRYPTO_AES_ECB) {
            if (this.encrypt) {
                byArray = new byte[this.blockSize];
                new SecureRandom().nextBytes(byArray);
                if (this.mech == UcryptoMech.CRYPTO_AES_GCM) {
                    n2 = 96;
                }
            } else {
                throw new InvalidAlgorithmParameterException("Parameters required for decryption");
            }
        }
        this.init(bl, (byte[])key.getEncoded().clone(), byArray, n2, null);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                algorithmParameterSpec = this.mech == UcryptoMech.CRYPTO_AES_GCM ? algorithmParameters.getParameterSpec(GCMParameterSpec.class) : algorithmParameters.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
            }
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[this.updateLength(n2)];
            int n3 = this.update(byArray, n, n2, byArray2, 0, byArray2.length);
            if (n3 == 0) {
                return null;
            }
            if (byArray2.length != n3) {
                byArray2 = Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error", shortBufferException);
        }
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.update(byArray, n, n2, byArray2, n3, byArray2.length - n3);
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.mech != UcryptoMech.CRYPTO_AES_GCM) {
            throw new IllegalStateException("No AAD can be supplied");
        }
        if (this.keyValue == null) {
            throw new IllegalStateException("Need to initialize Cipher first before supplying AAD");
        }
        if (byArray == null || n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        this.aad = Arrays.copyOfRange(byArray, n, n + n2);
    }

    @Override
    protected synchronized byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.doFinalLength(n2)];
        try {
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (byArray2.length != n3) {
                byArray2 = Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error", shortBufferException);
        }
    }

    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        if (n2 != 0) {
            n4 = this.update(byArray, n, n2, byArray2, n3, byArray2.length - n3);
            n3 += n4;
        }
        return n4 += this.doFinal(byArray2, n3, byArray2.length - n3);
    }

    @Override
    protected synchronized byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new UcryptoException("Internal Error", badPaddingException);
        }
        return byArray;
    }

    @Override
    protected synchronized Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        Object var5_4 = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw (InvalidKeyException)new InvalidKeyException().initCause(exception);
        }
        return NativeCipher.constructKey(n, byArray2, string);
    }

    void reset(boolean bl) {
        this.initialized = false;
        this.bytesBuffered = 0;
        if (this.pCtxt != null) {
            this.pCtxt.dispose(bl);
            this.pCtxt = null;
        }
    }

    private static native long nativeInit(int var0, boolean var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private static native int nativeUpdate(long var0, boolean var2, byte[] var3, int var4, int var5, byte[] var6, int var7);

    private static native int nativeFinal(long var0, boolean var2, byte[] var3, int var4);

    private void init(boolean bl, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        this.reset(true);
        this.encrypt = bl;
        this.keyValue = byArray;
        this.iv = byArray2;
        this.tagLen = n;
        this.aad = byArray3;
        if (this.mech == UcryptoMech.CRYPTO_AES_GCM && byArray3 == null) {
            return;
        }
        long l = NativeCipher.nativeInit(this.mech.value(), bl, this.keyValue, this.iv, n, byArray3);
        boolean bl2 = this.initialized = l != 0L;
        if (!this.initialized) {
            throw new UcryptoException("Cannot initialize Cipher");
        }
        this.pCtxt = new CipherContextRef(this, l, bl);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.init(this.encrypt, this.keyValue, this.iv, this.tagLen, this.aad);
            if (!this.initialized) {
                throw new UcryptoException("Cannot initialize Cipher");
            }
        }
    }

    private int updateLength(int n) {
        if (n <= 0) {
            return 0;
        }
        return n + this.bytesBuffered;
    }

    private int doFinalLength(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = n + this.bytesBuffered;
        if (this.encrypt && this.mech == UcryptoMech.CRYPTO_AES_GCM) {
            n2 += this.tagLen / 8;
        }
        return n2;
    }

    private int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        if (n4 < this.updateLength(n2)) {
            throw new ShortBufferException();
        }
        this.ensureInitialized();
        if (n2 <= 0) {
            return 0;
        }
        int n5 = NativeCipher.nativeUpdate(this.pCtxt.id, this.encrypt, byArray, n, n2, byArray2, n3);
        if (n5 < 0) {
            this.reset(false);
            throw new UcryptoException(-n5);
        }
        this.bytesBuffered += n2 - n5;
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFinal(byte[] byArray, int n, int n2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n3 = this.doFinalLength(0);
        if (n2 < n3) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int n4 = NativeCipher.nativeFinal(this.pCtxt.id, this.encrypt, byArray, n);
            if (n4 < 0) {
                UcryptoException ucryptoException = new UcryptoException(-n4);
                if (ucryptoException.getMessage().equals("CRYPTO_INVALID_MAC") && this.mech == UcryptoMech.CRYPTO_AES_GCM) {
                    throw new AEADBadTagException();
                }
                throw ucryptoException;
            }
            int n5 = n4;
            return n5;
        }
        finally {
            this.reset(false);
        }
    }

    private static class CipherContextRef
    extends PhantomReference<NativeCipher>
    implements Comparable<CipherContextRef> {
        private static ReferenceQueue<NativeCipher> refQueue = new ReferenceQueue();
        private static Set<CipherContextRef> refList = new ConcurrentSkipListSet<CipherContextRef>();
        private final long id;
        private final boolean encrypt;

        private static void drainRefQueueBounded() {
            CipherContextRef cipherContextRef;
            while ((cipherContextRef = (CipherContextRef)refQueue.poll()) != null) {
                cipherContextRef.dispose(true);
            }
        }

        CipherContextRef(NativeCipher nativeCipher, long l, boolean bl) {
            super(nativeCipher, refQueue);
            this.id = l;
            this.encrypt = bl;
            refList.add(this);
            UcryptoProvider.debug("Resource: track Cipher Ctxt " + this.id);
            CipherContextRef.drainRefQueueBounded();
        }

        @Override
        public int compareTo(CipherContextRef cipherContextRef) {
            if (this.id == cipherContextRef.id) {
                return 0;
            }
            return this.id < cipherContextRef.id ? -1 : 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose(boolean bl) {
            refList.remove(this);
            try {
                if (bl) {
                    UcryptoProvider.debug("Resource: free Cipher Ctxt " + this.id);
                    int n = NativeCipher.nativeFinal(this.id, this.encrypt, null, 0);
                    if (n < 0) {
                        UcryptoProvider.debug("Resource: error freeing Cipher Ctxt " + this.id + " " + new UcryptoException(-n).getMessage());
                    }
                } else {
                    UcryptoProvider.debug("Resource: stop tracking Cipher Ctxt " + this.id);
                }
            }
            finally {
                this.clear();
            }
        }
    }

    public static final class AesCfb128NoPadding
    extends NativeCipher {
        public AesCfb128NoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CFB128, 16, NativeCipher.AES_KEY_ALGO);
        }
    }

    public static final class AesGcmNoPadding
    extends NativeCipher {
        public AesGcmNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_GCM, 16, NativeCipher.AES_KEY_ALGO);
        }
    }

    public static final class AesCtrNoPadding
    extends NativeCipher {
        public AesCtrNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CTR, 16, NativeCipher.AES_KEY_ALGO);
        }
    }

    public static final class AesCbcNoPadding
    extends NativeCipher {
        public AesCbcNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_CBC, 16, NativeCipher.AES_KEY_ALGO);
        }
    }

    public static final class AesEcbNoPadding
    extends NativeCipher {
        public AesEcbNoPadding() throws NoSuchAlgorithmException {
            super(UcryptoMech.CRYPTO_AES_ECB, 16, NativeCipher.AES_KEY_ALGO);
        }
    }
}

