/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixCopyFile;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class SolarisUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private final UnixPath file;
    private final boolean followLinks;

    private byte[] nameAsBytes(UnixPath unixPath, String string) throws IOException {
        byte[] byArray = string.getBytes();
        if ((byArray.length == 0 || byArray[0] == 46) && (byArray.length <= 1 || byArray.length == 2 && byArray[1] == 46)) {
            throw new FileSystemException(unixPath.getPathForExceptionMessage(), null, "'" + string + "' is not a valid name");
        }
        return byArray;
    }

    SolarisUserDefinedFileAttributeView(UnixPath unixPath, boolean bl) {
        this.file = unixPath;
        this.followLinks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            Object object;
            long l;
            int n2 = UnixNativeDispatcher.openat(n, ".".getBytes(), 16384, 0);
            try {
                l = UnixNativeDispatcher.fdopendir(n2);
            }
            catch (UnixException unixException) {
                UnixNativeDispatcher.close(n2);
                throw unixException;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while ((object = UnixNativeDispatcher.readdir(l)) != null) {
                    String string = new String((byte[])object);
                    if (string.equals(".") || string.equals("..")) continue;
                    arrayList.add(string);
                }
            }
            finally {
                UnixNativeDispatcher.closedir(l);
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get list of extended attributes: " + unixException.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n2;
            int n3 = UnixNativeDispatcher.openat(n, this.nameAsBytes(this.file, string), 16384, 0);
            try {
                UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(n3);
                long l = unixFileAttributes.size();
                if (l > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Extended attribute value too large");
                }
                n2 = (int)l;
            }
            catch (Throwable throwable) {
                try {
                    UnixNativeDispatcher.close(n3);
                    throw throwable;
                }
                catch (UnixException unixException) {
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get size of extended attribute '" + string + "': " + unixException.getMessage());
                }
            }
            UnixNativeDispatcher.close(n3);
            return n2;
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String string, ByteBuffer byteBuffer) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n2;
            int n3 = UnixNativeDispatcher.openat(n, this.nameAsBytes(this.file, string), 16384, 0);
            FileChannel fileChannel = UnixChannelFactory.newFileChannel(n3, this.file.toString(), true, false);
            try {
                if (fileChannel.size() > (long)byteBuffer.remaining()) {
                    throw new IOException("Extended attribute file too large");
                }
                int n4 = 0;
                while (byteBuffer.hasRemaining() && (n2 = fileChannel.read(byteBuffer)) >= 0) {
                    n4 += n2;
                }
                n2 = n4;
            }
            catch (Throwable throwable) {
                try {
                    fileChannel.close();
                    throw throwable;
                }
                catch (UnixException unixException) {
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to read extended attribute '" + string + "': " + unixException.getMessage());
                }
            }
            fileChannel.close();
            return n2;
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String string, ByteBuffer byteBuffer) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n2;
            int n3 = UnixNativeDispatcher.openat(n, this.nameAsBytes(this.file, string), 17153, 511);
            FileChannel fileChannel = UnixChannelFactory.newFileChannel(n3, this.file.toString(), false, true);
            try {
                int n4 = byteBuffer.remaining();
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                n2 = n4;
            }
            catch (Throwable throwable) {
                try {
                    fileChannel.close();
                    throw throwable;
                }
                catch (UnixException unixException) {
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to write extended attribute '" + string + "': " + unixException.getMessage());
                }
            }
            fileChannel.close();
            return n2;
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n2 = UnixNativeDispatcher.openat(n, ".".getBytes(), 16384, 0);
            try {
                UnixNativeDispatcher.unlinkat(n2, this.nameAsBytes(this.file, string), 0);
            }
            finally {
                UnixNativeDispatcher.close(n2);
            }
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to delete extended attribute '" + string + "': " + unixException.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyExtendedAttributes(int n, int n2) {
        try {
            int n3 = UnixNativeDispatcher.openat(n, ".".getBytes(), 16384, 0);
            long l = 0L;
            try {
                l = UnixNativeDispatcher.fdopendir(n3);
            }
            catch (UnixException unixException) {
                UnixNativeDispatcher.close(n3);
                throw unixException;
            }
            try {
                byte[] byArray;
                while ((byArray = UnixNativeDispatcher.readdir(l)) != null) {
                    if (byArray[0] == 46 && (byArray.length == 1 || byArray.length == 2 && byArray[1] == 46)) continue;
                    SolarisUserDefinedFileAttributeView.copyExtendedAttribute(n, byArray, n2);
                }
            }
            finally {
                UnixNativeDispatcher.closedir(l);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyExtendedAttribute(int n, byte[] byArray, int n2) throws UnixException {
        int n3 = UnixNativeDispatcher.openat(n, byArray, 16384, 0);
        try {
            int n4 = UnixNativeDispatcher.openat(n2, byArray, 17153, 511);
            try {
                UnixCopyFile.transfer(n4, n3, 0L);
            }
            finally {
                UnixNativeDispatcher.close(n4);
            }
        }
        finally {
            UnixNativeDispatcher.close(n3);
        }
    }
}

