/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.spi.FileTypeDetector;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.GnomeFileTypeDetector;
import sun.nio.fs.SolarisAclFileAttributeView;
import sun.nio.fs.SolarisFileStore;
import sun.nio.fs.SolarisFileSystem;
import sun.nio.fs.SolarisUserDefinedFileAttributeView;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

public class SolarisFileSystemProvider
extends UnixFileSystemProvider {
    @Override
    SolarisFileSystem newFileSystem(String string) {
        return new SolarisFileSystem(this, string);
    }

    @Override
    SolarisFileStore getFileStore(UnixPath unixPath) throws IOException {
        return new SolarisFileStore(unixPath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        if (clazz == AclFileAttributeView.class) {
            return (V)new SolarisAclFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            return (V)new SolarisUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, clazz, linkOptionArray);
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        if (string.equals("acl")) {
            return new SolarisAclFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (string.equals("user")) {
            return new SolarisUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, string, linkOptionArray);
    }

    @Override
    FileTypeDetector getFileTypeDetector() {
        return new GnomeFileTypeDetector();
    }
}

