/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SolarisEventPort;
import sun.security.action.GetIntegerAction;

class EventPortWrapper {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int addressSize = unsafe.addressSize();
    static final int OPEN_MAX = IOUtil.fdLimit();
    static final int POLL_MAX = Math.min(OPEN_MAX - 1, 1024);
    private final int INITIAL_PENDING_UPDATE_SIZE = 256;
    private static final int MAX_UPDATE_ARRAY_SIZE = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxUpdateArraySize", Math.min(OPEN_MAX, 65536)));
    private static final byte IGNORE = -1;
    private final int pfd;
    private final long pollArrayAddress;
    private final AllocatedNativeObject pollArray;
    private final Object updateLock = new Object();
    private int updateCount;
    private int[] updateDescriptors = new int[256];
    private final byte[] eventsLow = new byte[MAX_UPDATE_ARRAY_SIZE];
    private Map<Integer, Byte> eventsHigh;
    private final BitSet registered = new BitSet();
    private BitSet visited = new BitSet();
    private boolean interrupted;

    EventPortWrapper() throws IOException {
        int n = POLL_MAX * SolarisEventPort.SIZEOF_PORT_EVENT;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        this.pfd = SolarisEventPort.port_create();
        if (OPEN_MAX > MAX_UPDATE_ARRAY_SIZE) {
            this.eventsHigh = new HashMap<Integer, Byte>();
        }
    }

    void close() throws IOException {
        SolarisEventPort.port_close(this.pfd);
        this.pollArray.free();
    }

    private short getSource(int n) {
        int n2 = SolarisEventPort.SIZEOF_PORT_EVENT * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getEventOps(int n) {
        int n2 = SolarisEventPort.SIZEOF_PORT_EVENT * n + 0;
        return this.pollArray.getInt(n2);
    }

    int getDescriptor(int n) {
        int n2 = SolarisEventPort.SIZEOF_PORT_EVENT * n + 8;
        if (addressSize == 4) {
            return this.pollArray.getInt(n2);
        }
        return (int)this.pollArray.getLong(n2);
    }

    private void setDescriptor(int n, int n2) {
        int n3 = SolarisEventPort.SIZEOF_PORT_EVENT * n + 8;
        if (addressSize == 4) {
            this.pollArray.putInt(n3, n2);
        } else {
            this.pollArray.putLong(n3, n2);
        }
    }

    private void setUpdate(int n, byte by) {
        if (n < MAX_UPDATE_ARRAY_SIZE) {
            this.eventsLow[n] = by;
        } else {
            this.eventsHigh.put(n, by);
        }
    }

    private byte getUpdate(int n) {
        if (n < MAX_UPDATE_ARRAY_SIZE) {
            return this.eventsLow[n];
        }
        Byte by = this.eventsHigh.get(n);
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int poll(long l) throws IOException {
        int n;
        int n2;
        Object object = this.updateLock;
        synchronized (object) {
            for (int i = this.updateCount - 1; i >= 0; --i) {
                n2 = this.updateDescriptors[i];
                if (this.visited.get(n2)) continue;
                n = this.getUpdate(n2);
                if (n != -1) {
                    if (n == 0) {
                        if (this.registered.get(n2)) {
                            SolarisEventPort.port_dissociate(this.pfd, 4, n2);
                            this.registered.clear(n2);
                        }
                    } else if (SolarisEventPort.port_associate(this.pfd, 4, n2, n)) {
                        this.registered.set(n2);
                    }
                }
                this.visited.set(n2);
            }
            this.updateCount = 0;
        }
        int n3 = SolarisEventPort.port_getn(this.pfd, this.pollArrayAddress, POLL_MAX, l);
        Object object2 = this.updateLock;
        synchronized (object2) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.getSource(n2) == 3) {
                    this.interrupted = true;
                    this.setDescriptor(n2, -1);
                    continue;
                }
                n = this.getDescriptor(n2);
                this.registered.clear(n);
                this.setInterest(n);
            }
        }
        return n3;
    }

    private void setInterest(int n) {
        assert (Thread.holdsLock(this.updateLock));
        int n2 = this.updateDescriptors.length;
        if (this.updateCount >= n2) {
            int n3 = n2 + 256;
            int[] nArray = new int[n3];
            System.arraycopy(this.updateDescriptors, 0, nArray, 0, n2);
            this.updateDescriptors = nArray;
        }
        this.updateDescriptors[this.updateCount++] = n;
        this.visited.clear(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        Object object = this.updateLock;
        synchronized (object) {
            this.setInterest(n);
            this.setUpdate(n, (byte)n2);
            assert (this.getUpdate(n) == n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.registered.get(n)) {
                try {
                    SolarisEventPort.port_dissociate(this.pfd, 4, n);
                }
                catch (IOException iOException) {
                    InternalError internalError = new InternalError(iOException.getMessage());
                    internalError.initCause(iOException);
                    throw internalError;
                }
                this.registered.clear(n);
            }
            this.setUpdate(n, (byte)-1);
        }
    }

    public void interrupt() {
        try {
            SolarisEventPort.port_send(this.pfd, 0);
        }
        catch (IOException iOException) {
            InternalError internalError = new InternalError(iOException.getMessage());
            internalError.initCause(iOException);
            throw internalError;
        }
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }
}

