/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.GCMParameterSpec;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class GCMParameters
extends AlgorithmParametersSpi {
    private byte[] iv;
    private int tLen;

    private void setValues(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            throw new IOException("IV cannot be null");
        }
        if (n != 4 && n != 8 && (n < 12 || n > 16)) {
            throw new IOException("Unsupported tag length: " + n);
        }
        this.iv = byArray;
        this.tLen = n;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.iv);
        derOutputStream2.putInteger(this.tLen);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (GCMParameterSpec.class.isAssignableFrom(clazz)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new GCMParameterSpec(this.tLen * 8, (byte[])this.iv.clone())));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
        try {
            this.setValues(gCMParameterSpec.getIV(), gCMParameterSpec.getTLen() / 8);
        }
        catch (IOException iOException) {
            throw new InvalidParameterSpecException(iOException.getMessage());
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("GCM parameter parsing error: SEQ tag expected");
        }
        derValue.data.reset();
        this.setValues(derValue.data.getOctetString(), derValue.data.getInteger());
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return "IV=" + Arrays.toString(this.iv) + ", tLen=" + this.tLen * 8;
    }
}

