/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp;

import com.sun.jmx.snmp.IPAcl.SnmpAcl;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.FileSystem;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.NotificationTarget;
import sun.management.snmp.jvminstr.NotificationTargetImpl;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

public final class AdaptorBootstrap {
    private static final MibLogger log = new MibLogger(AdaptorBootstrap.class);
    private SnmpAdaptorServer adaptor;
    private JVM_MANAGEMENT_MIB_IMPL jvmmib;

    private AdaptorBootstrap(SnmpAdaptorServer snmpAdaptorServer, JVM_MANAGEMENT_MIB_IMPL jVM_MANAGEMENT_MIB_IMPL) {
        this.jvmmib = jVM_MANAGEMENT_MIB_IMPL;
        this.adaptor = snmpAdaptorServer;
    }

    private static String getDefaultFileName(String string) {
        String string2 = File.separator;
        return System.getProperty("java.home") + string2 + "lib" + string2 + "management" + string2 + string;
    }

    private static List<NotificationTarget> getTargetList(InetAddressAcl inetAddressAcl, int n) {
        ArrayList<NotificationTarget> arrayList = new ArrayList<NotificationTarget>();
        if (inetAddressAcl != null) {
            if (log.isDebugOn()) {
                log.debug("getTargetList", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.processing"));
            }
            Enumeration enumeration = inetAddressAcl.getTrapDestinations();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = (InetAddress)enumeration.nextElement();
                Enumeration enumeration2 = inetAddressAcl.getTrapCommunities(inetAddress);
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    NotificationTargetImpl notificationTargetImpl = new NotificationTargetImpl(inetAddress, n, string);
                    if (log.isDebugOn()) {
                        log.debug("getTargetList", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.adding", ((Object)notificationTargetImpl).toString()));
                    }
                    arrayList.add(notificationTargetImpl);
                }
            }
        }
        return arrayList;
    }

    public static synchronized AdaptorBootstrap initialize() {
        Properties properties = Agent.loadManagementProperties();
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("com.sun.management.snmp.port");
        return AdaptorBootstrap.initialize(string, properties);
    }

    public static synchronized AdaptorBootstrap initialize(String string, Properties properties) {
        int n;
        int n2;
        if (string.length() == 0) {
            string = "161";
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.port", (Throwable)numberFormatException, string);
        }
        if (n2 < 0) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.port", string);
        }
        String string2 = properties.getProperty("com.sun.management.snmp.trap", "162");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.trap.port", (Throwable)numberFormatException, string2);
        }
        if (n < 0) {
            throw new AgentConfigurationError("agent.err.invalid.snmp.trap.port", string2);
        }
        String string3 = properties.getProperty("com.sun.management.snmp.interface", "localhost");
        String string4 = AdaptorBootstrap.getDefaultFileName("snmp.acl");
        String string5 = properties.getProperty("com.sun.management.snmp.acl.file", string4);
        String string6 = properties.getProperty("com.sun.management.snmp.acl", "true");
        boolean bl = Boolean.valueOf(string6);
        if (bl) {
            AdaptorBootstrap.checkAclFile(string5);
        }
        AdaptorBootstrap adaptorBootstrap = null;
        try {
            adaptorBootstrap = AdaptorBootstrap.getAdaptorBootstrap(n2, n, string3, bl, string5);
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)exception, exception.getMessage());
        }
        return adaptorBootstrap;
    }

    private static AdaptorBootstrap getAdaptorBootstrap(int n, int n2, String string, boolean bl, String string2) {
        SnmpAcl snmpAcl;
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AgentConfigurationError("agent.err.unknown.snmp.interface", (Throwable)unknownHostException, string);
        }
        if (log.isDebugOn()) {
            log.debug("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.starting\n\tcom.sun.management.snmp.port=" + n + "\n\t" + "com.sun.management.snmp.trap" + "=" + n2 + "\n\t" + "com.sun.management.snmp.interface" + "=" + inetAddress + (bl ? "\n\tcom.sun.management.snmp.acl.file=" + string2 : "\n\tNo ACL") + ""));
        }
        try {
            snmpAcl = bl ? new SnmpAcl(System.getProperty("user.name"), string2) : null;
        }
        catch (UnknownHostException unknownHostException) {
            throw new AgentConfigurationError("agent.err.unknown.snmp.interface", (Throwable)unknownHostException, unknownHostException.getMessage());
        }
        SnmpAdaptorServer snmpAdaptorServer = new SnmpAdaptorServer(snmpAcl, n, inetAddress);
        snmpAdaptorServer.setUserDataFactory(new JvmContextFactory());
        snmpAdaptorServer.setTrapPort(n2);
        JVM_MANAGEMENT_MIB_IMPL jVM_MANAGEMENT_MIB_IMPL = new JVM_MANAGEMENT_MIB_IMPL();
        try {
            jVM_MANAGEMENT_MIB_IMPL.init();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AgentConfigurationError("agent.err.snmp.mib.init.failed", (Throwable)illegalAccessException, illegalAccessException.getMessage());
        }
        jVM_MANAGEMENT_MIB_IMPL.addTargets(AdaptorBootstrap.getTargetList(snmpAcl, n2));
        try {
            snmpAdaptorServer.start(Long.MAX_VALUE);
        }
        catch (Exception exception) {
            Throwable throwable;
            Throwable throwable2 = exception;
            if (exception instanceof CommunicationException && (throwable = throwable2.getCause()) != null) {
                throwable2 = throwable;
            }
            throw new AgentConfigurationError("agent.err.snmp.adaptor.start.failed", throwable2, inetAddress + ":" + n, "(" + throwable2.getMessage() + ")");
        }
        if (!snmpAdaptorServer.isActive()) {
            throw new AgentConfigurationError("agent.err.snmp.adaptor.start.failed", inetAddress + ":" + n);
        }
        try {
            snmpAdaptorServer.addMib(jVM_MANAGEMENT_MIB_IMPL);
            jVM_MANAGEMENT_MIB_IMPL.setSnmpAdaptor(snmpAdaptorServer);
        }
        catch (RuntimeException runtimeException) {
            new AdaptorBootstrap(snmpAdaptorServer, jVM_MANAGEMENT_MIB_IMPL).terminate();
            throw runtimeException;
        }
        log.debug("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.initialize1"));
        log.config("initialize", Agent.getText("jmxremote.AdaptorBootstrap.getTargetList.initialize2", inetAddress.toString(), Integer.toString(snmpAdaptorServer.getPort())));
        return new AdaptorBootstrap(snmpAdaptorServer, jVM_MANAGEMENT_MIB_IMPL);
    }

    private static void checkAclFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.acl.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.acl.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.acl.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                throw new AgentConfigurationError("agent.err.acl.file.access.notrestricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.acl.file.read.failed", string);
        }
    }

    public synchronized int getPort() {
        if (this.adaptor != null) {
            return this.adaptor.getPort();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (this.adaptor == null) {
            return;
        }
        try {
            this.jvmmib.terminate();
        }
        catch (Exception exception) {
            log.debug("jmxremote.AdaptorBootstrap.getTargetList.terminate", exception.toString());
        }
        finally {
            this.jvmmib = null;
        }
        try {
            this.adaptor.stop();
        }
        finally {
            this.adaptor = null;
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.snmp.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String TRAP_PORT = "com.sun.management.snmp.trap";
        public static final String USE_ACL = "com.sun.management.snmp.acl";
        public static final String ACL_FILE_NAME = "com.sun.management.snmp.acl.file";
        public static final String BIND_ADDRESS = "com.sun.management.snmp.interface";
    }

    public static interface DefaultValues {
        public static final String PORT = "161";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String TRAP_PORT = "162";
        public static final String USE_ACL = "true";
        public static final String ACL_FILE_NAME = "snmp.acl";
        public static final String BIND_ADDRESS = "localhost";
    }
}

